"use strict";

System.register(["jquery", "lodash", "moment"], function (_export, _context) {
    "use strict";

    var $, _, moment, _typeof, _slicedToArray, _createClass, ArtmonDatasource;

    function _classCallCheck(instance, Constructor) {
        if (!(instance instanceof Constructor)) {
            throw new TypeError("Cannot call a class as a function");
        }
    }

    function getName(point) {
        var _iteratorNormalCompletion = true;
        var _didIteratorError = false;
        var _iteratorError = undefined;

        try {
            for (var _iterator = Object.keys(point)[Symbol.iterator](), _step; !(_iteratorNormalCompletion = (_step = _iterator.next()).done); _iteratorNormalCompletion = true) {
                var property = _step.value;

                if (property != "utc" && property != "series_id") {
                    return property;
                }
            }
        } catch (err) {
            _didIteratorError = true;
            _iteratorError = err;
        } finally {
            try {
                if (!_iteratorNormalCompletion && _iterator.return) {
                    _iterator.return();
                }
            } finally {
                if (_didIteratorError) {
                    throw _iteratorError;
                }
            }
        }

        return undefined;
    }

    return {
        setters: [function (_jquery) {
            $ = _jquery.default;
        }, function (_lodash) {
            _ = _lodash.default;
        }, function (_moment) {
            moment = _moment.default;
        }],
        execute: function () {
            _typeof = typeof Symbol === "function" && typeof Symbol.iterator === "symbol" ? function (obj) {
                return typeof obj;
            } : function (obj) {
                return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
            };

            _slicedToArray = function () {
                function sliceIterator(arr, i) {
                    var _arr = [];
                    var _n = true;
                    var _d = false;
                    var _e = undefined;

                    try {
                        for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) {
                            _arr.push(_s.value);

                            if (i && _arr.length === i) break;
                        }
                    } catch (err) {
                        _d = true;
                        _e = err;
                    } finally {
                        try {
                            if (!_n && _i["return"]) _i["return"]();
                        } finally {
                            if (_d) throw _e;
                        }
                    }

                    return _arr;
                }

                return function (arr, i) {
                    if (Array.isArray(arr)) {
                        return arr;
                    } else if (Symbol.iterator in Object(arr)) {
                        return sliceIterator(arr, i);
                    } else {
                        throw new TypeError("Invalid attempt to destructure non-iterable instance");
                    }
                };
            }();

            _createClass = function () {
                function defineProperties(target, props) {
                    for (var i = 0; i < props.length; i++) {
                        var descriptor = props[i];
                        descriptor.enumerable = descriptor.enumerable || false;
                        descriptor.configurable = true;
                        if ("value" in descriptor) descriptor.writable = true;
                        Object.defineProperty(target, descriptor.key, descriptor);
                    }
                }

                return function (Constructor, protoProps, staticProps) {
                    if (protoProps) defineProperties(Constructor.prototype, protoProps);
                    if (staticProps) defineProperties(Constructor, staticProps);
                    return Constructor;
                };
            }();

            _export("ArtmonDatasource", ArtmonDatasource = function () {
                function ArtmonDatasource(instanceSettings, $q, backendSrv, templateSrv) {
                    _classCallCheck(this, ArtmonDatasource);

                    this.artmon = "https://artmon.bsadm.yandex-team.ru";
                    this.name = instanceSettings.name;
                    this.type = instanceSettings.type;
                    this.url = instanceSettings.url;
                    this.q = $q;
                    this.backendSrv = backendSrv;
                    this.templateSrv = templateSrv;
                    this.cache = new Map();
                    this.seriesBlacklist = new Set();
                }

                _createClass(ArtmonDatasource, [{
                    key: "paramsToUrl",
                    value: function paramsToUrl(url, params) {
                        var realParams = [];
                        var _iteratorNormalCompletion2 = true;
                        var _didIteratorError2 = false;
                        var _iteratorError2 = undefined;

                        try {
                            for (var _iterator2 = params[Symbol.iterator](), _step2; !(_iteratorNormalCompletion2 = (_step2 = _iterator2.next()).done); _iteratorNormalCompletion2 = true) {
                                var _step2$value = _slicedToArray(_step2.value, 2),
                                    name = _step2$value[0],
                                    value = _step2$value[1];

                                realParams.push({
                                    name: name,
                                    value: value
                                });
                            }
                        } catch (err) {
                            _didIteratorError2 = true;
                            _iteratorError2 = err;
                        } finally {
                            try {
                                if (!_iteratorNormalCompletion2 && _iterator2.return) {
                                    _iterator2.return();
                                }
                            } finally {
                                if (_didIteratorError2) {
                                    throw _iteratorError2;
                                }
                            }
                        }

                        return url + "?" + $.param(realParams);
                    }
                }, {
                    key: "formArtmonUrl",
                    value: function formArtmonUrl() {}
                }, {
                    key: "query",
                    value: function query(options) {
                        var _this = this;

                        var variables = new Map();
                        var _iteratorNormalCompletion3 = true;
                        var _didIteratorError3 = false;
                        var _iteratorError3 = undefined;

                        try {
                            for (var _iterator3 = this.templateSrv.getVariables()[Symbol.iterator](), _step3; !(_iteratorNormalCompletion3 = (_step3 = _iterator3.next()).done); _iteratorNormalCompletion3 = true) {
                                var variable = _step3.value;

                                variables.set(variable.name, variable.current.value);
                            }
                        } catch (err) {
                            _didIteratorError3 = true;
                            _iteratorError3 = err;
                        } finally {
                            try {
                                if (!_iteratorNormalCompletion3 && _iterator3.return) {
                                    _iterator3.return();
                                }
                            } finally {
                                if (_didIteratorError3) {
                                    throw _iteratorError3;
                                }
                            }
                        }

                        var _iteratorNormalCompletion4 = true;
                        var _didIteratorError4 = false;
                        var _iteratorError4 = undefined;

                        try {
                            var _loop = function _loop() {
                                var target = _step4.value;

                                var chart = target.chart === "default" ? variables.get("chart") : target.chart;
                                var compareWith = target.compareWith === "default" ? variables.get("compareWith") : target.compareWith;
                                var timegroup = target.timegroup === "default" ? variables.get("timegroup") : target.timegroup;
                                var compare = (target.compare === "default" ? variables.get("compare") : target.compare) || "1";

                                var period_start = options.range.from.clone().subtract(1, "hours");
                                var period_end = options.range.to.clone().add(1, "hours");
                                var blacklist = variables.get("seriesBlacklist");
                                _this.seriesBlacklist = new Set(Array.isArray(blacklist) ? blacklist : [blacklist]) || new Set();

                                var httpParams = new Map();
                                additional_minutes = _this.period * 24 * 60 * 20 / 100;

                                var compare_end = period_end.clone().subtract(compareWith, "days").add(additional_minutes, "minutes");
                                var compare_start = period_start.clone().subtract(compareWith, "days");
                                if (compareWith === 365) {
                                    compare_start = period_start.clone().subtract(1, "years");
                                    var days_diff = period_start.day() - compare_start.day();
                                    compare_start.add((days_diff + 7) % 7, 'days');
                                }
                                var period_start_hour = period_start.format("HH");
                                var period_end_hour = period_end.format("HH");
                                var compare_start_hour = compare_start.format("HH");
                                var compare_end_hour = compare_end.format("HH");

                                httpParams.set("period_start", period_start.format("YYYY-MM-DD"));
                                httpParams.set("period_end", period_end.format("YYYY-MM-DD"));
                                httpParams.set("period_start_hour", new String(period_start_hour));
                                httpParams.set("period_end_hour", new String(period_end_hour));
                                httpParams.set("compare_start", compare_start.format("YYYY-MM-DD"));
                                httpParams.set("compare_end", compare_end.format("YYYY-MM-DD"));
                                httpParams.set("compare_start_hour", new String(period_start_hour));
                                httpParams.set("compare_end_hour", new String(compare_end_hour));
                                httpParams.set("compare_enabled", compare);
                                httpParams.set("ignore_fast", true);
                                httpParams.set("timegroup", timegroup);
                                httpParams.set("query", target.query);
                                httpParams.set("periodicity", target.periodicity);
                                httpParams.set("module", target.module);

                                var url = _this.paramsToUrl(_this.artmon + "/cgi-bin/data.cgi", httpParams);
                                if (_this.cache.has(url)) {
                                    var data = _this.cache.get(url);
                                    return {
                                        v: _this.processData(data, compareWith * 24 * 60 * 60 * 1000, chart)
                                    };
                                }
                                return {
                                    v: fetch(url, {
                                        credentials: "include",
                                        method: "GET",
                                        mode: "cors",
                                        redirect: "follow"
                                    }).then(function (response) {
                                        return response.json();
                                    }).catch(function () {
                                        return {
                                            data: []
                                        };
                                    }).then(function (data) {
                                        _this.cache.delete(url);
                                        _this.cache.set(url, data);
                                        return _this.processData(data, compareWith * 24 * 60 * 60 * 1000, chart);
                                    }).catch(function () {
                                        return {
                                            data: []
                                        };
                                    })
                                };
                            };

                            for (var _iterator4 = options.targets[Symbol.iterator](), _step4; !(_iteratorNormalCompletion4 = (_step4 = _iterator4.next()).done); _iteratorNormalCompletion4 = true) {
                                var additional_minutes;

                                var _ret = _loop();

                                if ((typeof _ret === "undefined" ? "undefined" : _typeof(_ret)) === "object") return _ret.v;
                            }
                        } catch (err) {
                            _didIteratorError4 = true;
                            _iteratorError4 = err;
                        } finally {
                            try {
                                if (!_iteratorNormalCompletion4 && _iterator4.return) {
                                    _iterator4.return();
                                }
                            } finally {
                                if (_didIteratorError4) {
                                    throw _iteratorError4;
                                }
                            }
                        }
                    }
                }, {
                    key: "processData",
                    value: function processData(data, compareWith, chart) {
                        var seriesOptions = data.items.series_options;
                        var series = [].concat(this.processSeries(data.items.rows, "", seriesOptions, chart)).concat(this.processSeries(data.items.compared, "compared", seriesOptions, chart, compareWith)).concat(this.processSeries(data.items.fraud_rows, "fraud", seriesOptions, chart));
                        return {
                            data: series
                        };
                    }
                }, {
                    key: "processSeries",
                    value: function processSeries(points, type, seriesOptions, chart, compareWith) {
                        if (points === undefined) {
                            return [];
                        }
                        var seriesByChart = new Map();
                        var _iteratorNormalCompletion5 = true;
                        var _didIteratorError5 = false;
                        var _iteratorError5 = undefined;

                        try {
                            for (var _iterator5 = points[Symbol.iterator](), _step5; !(_iteratorNormalCompletion5 = (_step5 = _iterator5.next()).done); _iteratorNormalCompletion5 = true) {
                                var point = _step5.value;

                                var seriesId = point["series_id"];
                                var utc = point.utc;
                                var valueName = getName(point);
                                if (!seriesByChart.has(valueName)) {
                                    seriesByChart.set(valueName, new Map());
                                }
                                if (!seriesByChart.get(valueName).has(seriesId)) {
                                    seriesByChart.get(valueName).set(seriesId, []);
                                }
                                seriesByChart.get(valueName).get(seriesId).push([point[valueName], utc]);
                            }
                        } catch (err) {
                            _didIteratorError5 = true;
                            _iteratorError5 = err;
                        } finally {
                            try {
                                if (!_iteratorNormalCompletion5 && _iterator5.return) {
                                    _iterator5.return();
                                }
                            } finally {
                                if (_didIteratorError5) {
                                    throw _iteratorError5;
                                }
                            }
                        }

                        var allSeries = new Map();
                        var _iteratorNormalCompletion6 = true;
                        var _didIteratorError6 = false;
                        var _iteratorError6 = undefined;

                        try {
                            for (var _iterator6 = seriesByChart[Symbol.iterator](), _step6; !(_iteratorNormalCompletion6 = (_step6 = _iterator6.next()).done); _iteratorNormalCompletion6 = true) {
                                var _step6$value = _slicedToArray(_step6.value, 2),
                                    _valueName = _step6$value[0],
                                    _chart = _step6$value[1];

                                if (!allSeries.has(_valueName)) {
                                    allSeries.set(_valueName, new Map());
                                }
                                var _iteratorNormalCompletion8 = true;
                                var _didIteratorError8 = false;
                                var _iteratorError8 = undefined;

                                try {
                                    for (var _iterator8 = _chart[Symbol.iterator](), _step8; !(_iteratorNormalCompletion8 = (_step8 = _iterator8.next()).done); _iteratorNormalCompletion8 = true) {
                                        var _step8$value = _slicedToArray(_step8.value, 2),
                                            _seriesId = _step8$value[0],
                                            _series = _step8$value[1];

                                        var nameSuffix = "";
                                        switch (type) {
                                            case "compared":
                                                for (var i = 0; i < _series.length; ++i) {
                                                    _series[i][1] += compareWith;
                                                }
                                                nameSuffix = " - prev";
                                                break;
                                            case "fraud_rows":
                                                nameSuffix = " - fraud";
                                                break;
                                        }
                                        _series.sort(function (a, b) {
                                            return a[1] - b[1];
                                        }).pop();
                                        if (seriesOptions[_seriesId] === undefined) {
                                            seriesOptions[_seriesId] = {
                                                name: _seriesId
                                            };
                                        }
                                        allSeries.get(_valueName).set(seriesOptions[_seriesId].name + nameSuffix, _series);
                                    }
                                } catch (err) {
                                    _didIteratorError8 = true;
                                    _iteratorError8 = err;
                                } finally {
                                    try {
                                        if (!_iteratorNormalCompletion8 && _iterator8.return) {
                                            _iterator8.return();
                                        }
                                    } finally {
                                        if (_didIteratorError8) {
                                            throw _iteratorError8;
                                        }
                                    }
                                }
                            }
                        } catch (err) {
                            _didIteratorError6 = true;
                            _iteratorError6 = err;
                        } finally {
                            try {
                                if (!_iteratorNormalCompletion6 && _iterator6.return) {
                                    _iterator6.return();
                                }
                            } finally {
                                if (_didIteratorError6) {
                                    throw _iteratorError6;
                                }
                            }
                        }

                        var series = [];
                        if (allSeries.has(chart)) {
                            var _iteratorNormalCompletion7 = true;
                            var _didIteratorError7 = false;
                            var _iteratorError7 = undefined;

                            try {
                                for (var _iterator7 = allSeries.get(chart)[Symbol.iterator](), _step7; !(_iteratorNormalCompletion7 = (_step7 = _iterator7.next()).done); _iteratorNormalCompletion7 = true) {
                                    var _step7$value = _slicedToArray(_step7.value, 2),
                                        target = _step7$value[0],
                                        datapoints = _step7$value[1];

                                    if (!this.seriesBlacklist.has(target)) {
                                        series.push({
                                            target: target,
                                            datapoints: datapoints
                                        });
                                    }
                                }
                            } catch (err) {
                                _didIteratorError7 = true;
                                _iteratorError7 = err;
                            } finally {
                                try {
                                    if (!_iteratorNormalCompletion7 && _iterator7.return) {
                                        _iterator7.return();
                                    }
                                } finally {
                                    if (_didIteratorError7) {
                                        throw _iteratorError7;
                                    }
                                }
                            }
                        }
                        return series;
                    }
                }, {
                    key: "testDatasource",
                    value: function testDatasource() {
                        return fetch(this.artmon + "/cgi-bin/data.cgi", {
                            credentials: "include",
                            method: "GET",
                            mode: "cors",
                            redirect: "follow"
                        }).then(function () {
                            return {
                                status: "success",
                                message: "Data source is working!",
                                title: "Success"
                            };
                        }).catch(function () {
                            return {
                                status: "fail",
                                message: "Artmon is inaccessible",
                                title: "Fail"
                            };
                        });
                    }
                }, {
                    key: "annotationQuery",
                    value: function annotationQuery(options) {
                        return [];
                    }
                }, {
                    key: "metricFindQuery",
                    value: function metricFindQuery(query) {}
                }]);

                return ArtmonDatasource;
            }());

            _export("ArtmonDatasource", ArtmonDatasource);
        }
    };
});
//# sourceMappingURL=datasource.js.map
