'use strict';

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.ArtmonQueryCtrl = undefined;

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _sdk = require('app/plugins/sdk');

var _lodash = require('lodash');

var _lodash2 = _interopRequireDefault(_lodash);

require('./css/query-editor.css!');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

var ArtmonQueryCtrl = exports.ArtmonQueryCtrl = function (_QueryCtrl) {
    _inherits(ArtmonQueryCtrl, _QueryCtrl);

    function ArtmonQueryCtrl($scope, $injector, uiSegmentSrv, templateSrv) {
        _classCallCheck(this, ArtmonQueryCtrl);

        var _this = _possibleConstructorReturn(this, (ArtmonQueryCtrl.__proto__ || Object.getPrototypeOf(ArtmonQueryCtrl)).call(this, $scope, $injector));

        _this.scope = $scope;
        _this.artmon = _this.scope.ctrl.datasource.artmon;
        _this.uiSegmentSrv = uiSegmentSrv;
        _this.templateSrv = templateSrv;
        _this.target.rawQuery = true;
        _this.target.compareWith = _this.target.compareWith || "default";
        _this.target.timegroup = _this.target.timegroup || "default";
        _this.target.chart = _this.target.chart || "default";
        _this.target.module = _this.target.module || "Traffic2";
        _this.target.periodicity = _this.target.periodicity || "undefined";
        _this.target.query = _this.target.query || "";
        _this.target.sliceUrl = _this.target.sliceUrl || _this.artmon + "/artmon-basic.cgi?";
        _this.target.compare = _this.target.compare || "1";
        return _this;
    }

    _createClass(ArtmonQueryCtrl, [{
        key: 'transformToSegments',
        value: function transformToSegments() {
            var _this2 = this;

            return function (results) {
                var segments = _lodash2.default.map(results, function (segment) {
                    return _this2.uiSegmentSrv.newSegment({
                        value: segment.value,
                        html: _this2.templateSrv.highlightVariablesAsHtml(segment.html),
                        expandable: true
                    });
                });

                return segments;
            };
        }
    }, {
        key: 'getCompare',
        value: function getCompare() {
            return new Promise(function (resolve) {
                resolve([{
                    html: "default",
                    value: "default"
                }, {
                    html: "1",
                    value: "1"
                }, {
                    html: "0",
                    value: "0"
                }]);
            });
        }
    }, {
        key: 'getChart',
        value: function getChart() {
            return new Promise(function (resolve) {
                resolve([{
                    html: "default",
                    value: "default"
                }, {
                    html: "bill_cost_shows",
                    value: "bill_cost_shows"
                }, {
                    html: "potential_CPC",
                    value: "potential_CPC"
                }, {
                    html: "source_cost_shows",
                    value: "source_cost_shows"
                }, {
                    html: "clicks",
                    value: "clicks"
                }, {
                    html: "xclicks",
                    value: "xclicks"
                }, {
                    html: "avg_source_cost_clicks",
                    value: "avg_source_cost_clicks"
                }, {
                    html: "avg_real_cost_shows",
                    value: "avg_real_cost_shows"
                }, {
                    html: "avg_source_cost_shows",
                    value: "avg_source_cost_shows"
                }, {
                    html: "ctr_factor",
                    value: "ctr_factor"
                }, {
                    html: "auction_amnesty",
                    value: "auction_amnesty"
                }, {
                    html: "cost",
                    value: "cost"
                }, {
                    html: "real_cost_clicks",
                    value: "real_cost_clicks"
                }, {
                    html: "real_amnesty",
                    value: "real_amnesty"
                }, {
                    html: "real_cost_shows",
                    value: "real_cost_shows"
                }, {
                    html: "source_cost_clicks",
                    value: "source_cost_clicks"
                }, {
                    html: "relevance",
                    value: "relevance"
                }, {
                    html: "cpc",
                    value: "cpc"
                }, {
                    html: "cpm",
                    value: "cpm"
                }, {
                    html: "avg_rank",
                    value: "avg_rank"
                }, {
                    html: "avg_real_cost_clicks",
                    value: "avg_real_cost_clicks"
                }, {
                    html: "rank",
                    value: "rank"
                }, {
                    html: "shows",
                    value: "shows"
                }, {
                    html: "ctr",
                    value: "ctr"
                }]);
            }).then(this.transformToSegments());
        }
    }, {
        key: 'getTimegroup',
        value: function getTimegroup() {
            return new Promise(function (resolve) {
                resolve([{
                    html: "default",
                    value: "default"
                }, {
                    html: "min",
                    value: "min"
                }, {
                    html: "hour",
                    value: "hour"
                }, {
                    html: "day",
                    value: "day"
                }, {
                    html: "week",
                    value: "week"
                }, {
                    html: "month",
                    value: "month"
                }]);
            }).then(this.transformToSegments());
        }
    }, {
        key: 'getCompareWith',
        value: function getCompareWith() {
            return new Promise(function (resolve) {
                resolve([{
                    html: "default",
                    value: "default"
                }, {
                    html: "1 day ago",
                    value: "1"
                }, {
                    html: "2 days ago",
                    value: "2"
                }, {
                    html: "1 week ago",
                    value: "7"
                }, {
                    html: "2 weeks ago",
                    value: "14"
                }, {
                    html: "4 weeks ago",
                    value: "28"
                }, {
                    html: "1 year ago",
                    value: "365"
                }]);
            }).then(this.transformToSegments());
        }
    }, {
        key: 'getModule',
        value: function getModule() {
            return new Promise(function (resolve) {
                resolve([{
                    html: "Traffic2",
                    value: "Traffic2"
                }, {
                    html: "DistributionMonitoring",
                    value: "DistributionMonitoring"
                }]);
            }).then(this.transformToSegments());
        }
    }, {
        key: 'getPeriodicity',
        value: function getPeriodicity() {
            return new Promise(function (resolve) {
                resolve([{
                    html: "undefined",
                    value: "undefined"
                }]);
            }).then(this.transformToSegments());
        }
    }, {
        key: 'onChangeInternal',
        value: function onChangeInternal() {
            this.panelCtrl.refresh();
        }
    }, {
        key: 'toggleEditorMode',
        value: function toggleEditorMode() {
            if (this.target.rawQuery) {
                var urlParams = new URL(this.target.sliceUrl).searchParams;
                this.target.compareWith = this.target.compareWith || "default";
                this.target.timegroup = this.target.timegroup || "default";
                this.target.chart = this.target.chart || "default";
                if (urlParams.has("module")) {
                    this.target.module = urlParams.get("module");
                }
                if (urlParams.has("periodicity")) {
                    this.target.periodicity = urlParams.get("periodicity");
                }
                if (urlParams.has("query")) {
                    this.target.query = urlParams.get("query");
                }
            } else {
                var httpParams = new Map([["query", this.target.query], ["module", this.target.module], ["periodicity", this.target.periodicity]]);
                this.target.sliceUrl = this.scope.ctrl.datasource.paramsToUrl(this.artmon + "/cgi-bin/artmon_basic.cgi", httpParams);
            }
            this.target.rawQuery = !this.target.rawQuery;
            this.onChangeInternal();
        }
    }]);

    return ArtmonQueryCtrl;
}(_sdk.QueryCtrl);

ArtmonQueryCtrl.templateUrl = 'partials/query.editor.html';
//# sourceMappingURL=query_ctrl.js.map
