#include "config.h"

#include <library/cpp/json/json_value.h>
#include <library/cpp/protobuf/json/json2proto.h>
#include <library/cpp/protobuf/util/pb_io.h>
#include <library/cpp/resource/resource.h>

#include <util/stream/file.h>


namespace NSolomon {
namespace NAgent {

void ParseConfig(const TString& filePath, TAgentConfig* config) {
    static auto options = EParseFromTextFormatOption::AllowUnknownField;
    try {
        ParseFromTextFormat(filePath, *config, options);
    } catch (...) {
        throw TConfigParseException() << CurrentExceptionMessage() << Endl;
    }
}

void ParseJsonConfig(const TString& filePath, TAgentConfig* config) {
    try {
        TFileInput in(filePath);
        NJson::TJsonReaderConfig readerConfig;
        readerConfig.DontValidateUtf8 = true;

        NJson::TJsonValue jsonValue;
        NJson::ReadJsonTree(&in, &readerConfig, &jsonValue, true);

        NProtobufJson::Json2Proto(jsonValue, *config,
                NProtobufJson::TJson2ProtoConfig().SetCastFromString(true));
    } catch (...) {
        throw TConfigParseException() << CurrentExceptionMessage() << Endl;
    }
}

void TestConfig(const TAgentConfig& config) {
    try {
        if (config.HasStorage()) {
            auto storageConfig = config.GetStorage();
            if (storageConfig.HasAggregationOptions()) {
                Y_ENSURE(!storageConfig.GetAggregationOptions().GetAggregationInterval().empty(),
                        "AggregationInterval value inside AggregationOptions is not specified");
            }
        }
    } catch (...) {
        throw TConfigTestException() << CurrentExceptionMessage() << Endl;
    }
}

void WriteConfigExample(IOutputStream* out) {
    (*out) << NResource::Find("example.conf") << Endl;
}

} // namespace NAgent
} // namespace NSolomon
