#pragma once

#include <solomon/agent/lib/auth/auth.h>
#include <solomon/agent/lib/http/handler.h>
#include <solomon/agent/lib/storage/common.h>
#include <solomon/agent/protos/http_server_config.pb.h>

namespace NSolomon {
namespace NAgent {

class TShardedStorage;

IHttpHandlerPtr CreateStorageShardsHandler(TShardedStorage* storage);
IHttpHandlerPtr CreateStorageFindHandler(TShardedStorage* storage, const TLabels& commonLabels);
IHttpHandlerPtr CreateStorageReadHandler(TShardedStorage* storage, const TLabels& commonLabels);

using TShardsConfigs = THashMap<TStorageShardId, THttpServerConfig::TShardConfig>;
IHttpHandlerPtr CreateStorageReadAllHandler(
        TShardedStorage* storage,
        const TLabels& commonLabels,
        TShardsConfigs&& shardsConfigs,
        IAuthProviderPtr debugAuthProvider);

} // namespace NAgent
} // namespace NSolomon
