PROGRAM(solomon-agent)

OWNER(g:solomon)

IF (OS_LINUX)
    ALLOCATOR(TCMALLOC_256K)
ENDIF()

SRCS(
    agent.cpp
    config.cpp
    storage_http_api.cpp
)

RESOURCE(
    solomon/agent/examples/example.conf example.conf
)

PEERDIR(
    library/cpp/getopt
    library/cpp/json
    library/cpp/json/writer
    library/cpp/protobuf/json
    library/cpp/protobuf/util
    library/cpp/resource
    library/cpp/string_utils/url
    solomon/agent/lib/auth
    solomon/agent/lib/config
    solomon/agent/lib/context
    solomon/agent/lib/http
    solomon/agent/lib/puller
    solomon/agent/lib/pusher
    solomon/agent/lib/python2
    solomon/agent/lib/selfmon/service
    solomon/agent/lib/selfmon/status
    solomon/agent/lib/storage
    solomon/agent/lib/thread
    solomon/agent/misc
    solomon/agent/protos
    solomon/libs/cpp/config_includes
    solomon/libs/cpp/multi_shard
    solomon/libs/cpp/multi_shard/proto
    solomon/libs/cpp/signals
    library/cpp/monlib/consumers
    library/cpp/monlib/encode/json
    library/cpp/monlib/encode/spack
    library/cpp/monlib/service
    library/cpp/monlib/service/pages
    # agent modules
    solomon/agent/modules/agent/python2
    solomon/agent/modules/agent/push
    solomon/agent/modules/agent/graphite
    # pull modules
    solomon/agent/modules/pull/http
    solomon/agent/modules/pull/porto
    solomon/agent/modules/pull/python2
    solomon/agent/modules/pull/system
    solomon/agent/modules/pull/unistat
    solomon/agent/modules/pull/systemd
    solomon/agent/modules/pull/nvidia_gpu
)

END()
