#
# free function to simplify configs creation
#
def system_pull_config(cpu=False, net=False, disk=False):
    return { 'System': {
        'MeasureCpu': cpu,
        'MeasureNet': net,
        'MeasureDisk': disk,
    }}


def python2_pull_config(file_path, module_name, class_name, params={}):
    config = {
        'FilePath': file_path,
        'ModuleName': module_name,
        'ClassName': class_name,
    }
    if params:
        config['Params'] = params
    return { 'Python2': config }


def service_config(project, service, modules, labels=[], pull_interval='15s'):
    return {
        'Project': project,
        'Service': service,
        'PullInterval': pull_interval,
        'Labels': labels,
        'Modules': modules
    }


#
# example of pull module (can be written in separate file)
#
class StockpilePullModule:
    def __init__(self, logger, registry, p1=None, p2=None, **other_params):
        self._reads = registry.counter({'request_type': 'READ'})
        self._writes = registry.counter({'request_type': 'WRITE'})
        logger.info("p1: %s, p2: %s" % (p1, p2))
        logger.info("other_params: %s" % other_params)

    def pull(self, ts, consumer):
        self._writes.inc()
        if self._writes.get() & 0x0f == 0:
            self._reads.inc()


#
# config loader
#
class MyConfigLoader:
    def __init__(self, logger, **other_params):
        logger.info("new instance of MyConfigLoader "
                    "with other_params={}".format(other_params))

    def load(self):
        return [
            service_config("solomon", "coremon", [
                system_pull_config(disk=True),
            ]),
            service_config("solomon", "stockpile", [
                python2_pull_config(__file__, "test", "StockpilePullModule", params={
                    'p1': 'one',
                    'p2': 'two',
                    'p3': 'three',
                })
            ])
        ]
