#include "auth.h"

#include <util/stream/file.h>


namespace NSolomon::NAgent {

NSolomon::IAuthProviderPtr CreateOAuthProvider(const OAuthConfig& conf) {
    const auto& tokenFilePath = conf.GetSecretFile();
    Y_ENSURE(!tokenFilePath.empty(), "file with an OAuth token is not specified");

    TFileInput in{tokenFilePath};
    auto token = Strip(in.ReadAll());
    Y_ENSURE(!token.empty(), "OAuth token is empty");

    return NSolomon::CreateOAuthProvider(token);
}

} // namespace NSolomon::NAgent
