#include "config_loader.h"

#include <solomon/agent/protos/loader_config.pb.h>

using namespace NSolomon::NAgent;

namespace {
class TStaticConfigLoader final: public IServiceConfigLoader {
public:
    TStaticConfigLoader(const TStaticConfig& config)
        : Config_(config)
    {
    }

private:
    TStringBuf Name() const override {
        return TStringBuf("StaticConfigLoader");
    }

    TDuration UpdateInterval() const override {
        return TDuration::Max();
    }

    TVector<TServiceConfig> Load() override {
        return {Config_.GetServices().begin(), Config_.GetServices().end()};
    }

private:
    TStaticConfig Config_;
};
}

IServiceConfigLoaderPtr NSolomon::NAgent::CreateStaticLoader(const TStaticConfig& config) {
    return MakeIntrusive<TStaticConfigLoader>(config);
}
