#pragma once

#include <solomon/agent/misc/labels.h>
#include <solomon/agent/protos/transformations_config.pb.h>

#include <library/cpp/monlib/metrics/metric_consumer.h>

namespace NSolomon::NAgent {

class ITransformingConsumer: public NMonitoring::IMetricConsumer {
public:
    virtual void SetInnerConsumer(IMetricConsumer* consumer) = 0;
};

using ITransformingConsumerPtr = THolder<ITransformingConsumer>;

ITransformingConsumerPtr CreateTransformingConsumer(const TTransformationsConfig* transformations);

TLabels ParseMatchLabels(TStringBuf str);
TLabels ParseReplaceMetaLabels(TStringBuf str);

} // namespace NSolomon::NAgent
