#pragma once

#include <solomon/agent/lib/auth/auth.h>
#include <solomon/agent/lib/thread/pool_provider.h>
#include <solomon/agent/protos/agent_config.pb.h>

#include <util/generic/ptr.h>


namespace NSolomon::NAgent {

class IAgentContext {
public:
    virtual ~IAgentContext() = default;

    virtual NSolomon::IAuthProviderPtr GetAuthProvider(TString name) const = 0;
    virtual NSolomon::IAuthProviderPtr GetAuthProvider(EClusterType cluster) const = 0;
    virtual TString GetCluster() const = 0;
    virtual bool DoBindBeforeConnect() const = 0;
};

const IAgentContext* ConstructAgentCtx(
        const TAgentConfig& config,
        NMonitoring::TMetricRegistry& registry,
        TTimerThread& timerThread,
        IThreadPoolProviderPtr threadPoolProvider);
const IAgentContext* GetAgentCtx();

} // namespace NSolomon::NAgent
