#pragma once

#include <library/cpp/http/misc/httpcodes.h>
#include <library/cpp/http/misc/httpreqdata.h>
#include <library/cpp/http/io/stream.h>
#include <library/cpp/http/server/response.h>

#include <util/memory/blob.h>


namespace NSolomon {
namespace NAgent {

///////////////////////////////////////////////////////////////////////////////
// THttpError
///////////////////////////////////////////////////////////////////////////////
class THttpError: public yexception {
public:
    inline explicit THttpError(HttpCodes code)
        : Code_(code)
    {
    }

    inline HttpCodes Code() const {
        return Code_;
    }

private:
    const HttpCodes Code_;
};

///////////////////////////////////////////////////////////////////////////////
// THttpRequest
///////////////////////////////////////////////////////////////////////////////
struct THttpRequest {
    const THttpInput& Input;
    const TServerRequestData& RD;
    const TBlob& Body;
};

///////////////////////////////////////////////////////////////////////////////
// IHttpHandler
///////////////////////////////////////////////////////////////////////////////
struct IHttpHandler {
    virtual ~IHttpHandler() = default;

    virtual void OnGet(const THttpRequest& req, THttpResponse* resp) const {
        Y_UNUSED(req);
        resp->SetHttpCode(HttpCodes::HTTP_METHOD_NOT_ALLOWED);
    }

    virtual void OnPost(const THttpRequest& req, THttpResponse* resp) {
        Y_UNUSED(req);
        resp->SetHttpCode(HttpCodes::HTTP_METHOD_NOT_ALLOWED);
    }
};

using IHttpHandlerPtr = THolder<IHttpHandler>;

///////////////////////////////////////////////////////////////////////////////
// basic handlers
///////////////////////////////////////////////////////////////////////////////
IHttpHandlerPtr CreateVersionHttpHandler();

} // namespace NAgent
} // namespace NSolomon
