#include "headers.h"

#include <library/cpp/svnversion/svnversion.h>

#include <util/string/cast.h>


namespace NSolomon {
namespace NAgent {

const TString FETCHER_ID_HEADER {"X-Solomon-FetcherId"};
const TString CLUSTER_ID_HEADER {"X-Solomon-ClusterId"};
const TString SEQ_NO_HEADER {"X-Solomon-SequenceNumber"};

const TString HAS_MORE_HEADER {"X-Solomon-HasMore"};
const TString NEXT_SEQ_NO_HEADER {"X-Solomon-NextSequenceNumber"};

const TString& AgentVersion() {
    static const int revision = GetArcadiaLastChangeNum();
    static const char* branch = GetBranch();
#ifndef IGNORE_SVNVERSION
    static const TString out(
            (revision > 0
             ? ToString(revision)
               + (strlen(branch)
                  ? ToString(".") + branch
                  : ToString(""))
             : ToString("")));
#else
    static const TString out(AGENT_HTTP_ID_PREFIX);
#endif
    return out;
}

#define AGENT_HTTP_ID_PREFIX "SolomonAgent"

const TString& AgentHttpId() {
    const TString& version = AgentVersion();

    static const TString out(AGENT_HTTP_ID_PREFIX
            + (version.empty()
                ? ToString("")
                : (ToString("/") + version)));
    return out;
}

const TString AGENT_VERSION = TString(AgentVersion());

const TString USER_AGENT_HEADER = TString(AgentHttpId());
const TString SERVER_HEADER = TString(AgentHttpId());

#undef AGENT_HTTP_ID_PREFIX

} // namespace NAgent
} // namespace NSolomon
