#pragma once

#include "handler.h"

#include <util/generic/noncopyable.h>

namespace NSolomon {
namespace NAgent {


class IServerStatusListener {
public:
    virtual ~IServerStatusListener() = default;
    virtual void OnRequestCompleted(TStringBuf path, HttpCodes code, TDuration time, ui64 responseBytes) noexcept = 0;
    virtual void OnRequest(TStringBuf path, ui64 payloadBytes) noexcept = 0;
};

using IServerStatusListenerPtr = THolder<IServerStatusListener>;


class THttpServerConfig;
class IThreadPoolProvider;

class THttpServer: private TNonCopyable {
public:
    THttpServer(const THttpServerConfig& config, IThreadPoolProvider& threadPoolProvider, IServerStatusListener* statusListener = nullptr);
    ~THttpServer();

    void Start();
    void Stop();

    void AddHandler(TStringBuf path, IHttpHandlerPtr handler);

    class TImpl;
private:
    THolder<TImpl> Impl_;
};

} // namespace NAgent
} // namespace NSolomon
