#include "handler.h"

#include <library/cpp/svnversion/svnversion.h>

namespace NSolomon {
namespace NAgent {
namespace {

struct TVersionHttpHandler: public IHttpHandler {
    void OnGet(const THttpRequest& req, THttpResponse* resp) const override {
        Y_UNUSED(req);
        resp->SetHttpCode(HttpCodes::HTTP_OK);
        resp->SetContentType(TStringBuf("text/plain"));
        resp->SetContent(GetProgramSvnVersion());
    }
};

} // namespace

IHttpHandlerPtr CreateVersionHttpHandler() {
    return MakeHolder<TVersionHttpHandler>();
}

} // namespace NAgent
} // namespace NSolomon
