#pragma once

#include <util/generic/ptr.h>

namespace NSolomon {
namespace NAgent {

struct IAgentModule: public TAtomicRefCount<IAgentModule> {
    virtual ~IAgentModule() = default;

    virtual void Start() = 0;
    virtual void Stop() = 0;
};

using IAgentModulePtr = TIntrusivePtr<IAgentModule>;

} // namespace NAgent
} // namespace NSolomon
