#pragma once

#include <library/cpp/monlib/metrics/metric_consumer.h>

#include <util/generic/ptr.h>
#include <util/generic/hash.h>

namespace NSolomon {
namespace NAgent {

struct IPullModule: public TAtomicRefCount<IPullModule> {
    virtual ~IPullModule() = default;

    virtual TStringBuf Name() const = 0;
    virtual ui64 Hash() const {
        return THash<TStringBuf>{}(Name());
    }

    virtual bool Equals(const IPullModule& other) const {
        return Name() == other.Name();
    }

    // non-zero return code indicates that this module should not be called anymore
    virtual int Pull(TInstant time, NMonitoring::IMetricConsumer* consumer) = 0;
};

using IPullModulePtr = TIntrusivePtr<IPullModule>;

inline bool operator==(const IPullModule& lhs, const IPullModule& rhs) {
    return lhs.Equals(rhs);
}

} // namespace NAgent
} // namespace NSolomon

template <>
struct THash<NSolomon::NAgent::IPullModulePtr> {
    ui64 operator()(const NSolomon::NAgent::IPullModulePtr& m) const {
        return m->Hash();
    }
};
