#pragma once

#include <solomon/agent/protos/transformations_config.pb.h>

#include <solomon/agent/lib/module/pull_module.h>
#include <solomon/agent/lib/storage/storage.h>
#include <solomon/agent/lib/thread/pool_provider.h>

#include <library/cpp/monlib/metrics/labels.h>

#include <util/datetime/base.h>
#include <util/thread/factory.h>

namespace NSolomon {
namespace NAgent {

class IShardConsumerProvider;

///////////////////////////////////////////////////////////////////////////////
// IDataPuller
///////////////////////////////////////////////////////////////////////////////
struct IDataPuller: public TAtomicRefCount<IDataPuller> {
    virtual ~IDataPuller() = default;

    virtual void Start() = 0;
    virtual void Stop() = 0;

    virtual void Schedule(IPullModulePtr module, TDuration period, IStorageConsumerProviderPtr consumerProvider,
                          const TTransformationsConfig* transformations = nullptr) = 0;
    virtual void Cancel(const IPullModule& module) noexcept = 0;
};

using IDataPullerPtr = TIntrusivePtr<IDataPuller>;

IDataPullerPtr CreateDataPuller(
        IThreadPool* pool,
        class TPullerStatus* status = nullptr,
        TDuration gcDelay = TDuration::Zero());

} // namespace NAgent
} // namespace NSolomon
