#pragma once

#include <solomon/agent/lib/consumers/grouping_encoder.h>
#include <solomon/agent/lib/registration/registration.h>
#include <solomon/agent/lib/storage/sharded_storage.h>
#include <solomon/agent/lib/thread/pool_provider.h>
#include <solomon/agent/protos/push_config.pb.h>

#include <util/datetime/base.h>
#include <util/generic/string.h>

namespace NSolomon::NAgent {

class IDataPusherStatusListener {
public:
    virtual ~IDataPusherStatusListener() = default;
    virtual void OnRequestCompleted(
            const TShardKey& shardKey,
            TString hostUrl,
            bool hasFailed,
            TDuration respTime) noexcept = 0;

    virtual void OnRequestStarted(const TShardKey& shardKey, TString hostUrl) noexcept = 0;
};

using IDataPusherStatusListenerPtr = TAtomicSharedPtr<IDataPusherStatusListener>;

class IDataPusher: public TAtomicRefCount<IDataPusher> {
public:
    virtual ~IDataPusher() = default;

    virtual void Start() = 0;
    virtual void Stop() = 0;

    virtual void Cancel(const TString& project, const TString& service) noexcept = 0;
};

using IDataPusherPtr = TIntrusivePtr<IDataPusher>;

IDataPusherPtr CreateDataPusher(
    TSimpleSharedPtr<IThreadPool> pool,
    const TPushConfig& pushConfig,
    const TLabels& commonLabels,
    TShardedStorage* storage,
    NMonitoring::TMetricRegistry& registry,
    TTimerThread& timer,
    TRegistrationTaskPtr registrationTask,
    IDataPusherStatusListenerPtr statusListener = nullptr
);

struct TEndpointInfo {
    TString Host;
    TString Endpoint;
};

TEndpointInfo BuildEndpoint(TStringBuf configHost, ui16 configPort, TStringBuf configUrl);

} // namespace NSolomon::NAgent
