#pragma once

#include "error.h"

#include <google/protobuf/message.h>

namespace NPython2 {

class TProtoConverter {
    using FieldDescriptor = google::protobuf::FieldDescriptor;

public:
    explicit TProtoConverter(google::protobuf::Message* message)
        : Message_(message)
        , Descr_(message->GetDescriptor())
        , Reflection_(message->GetReflection())
    {
    }

    void Convert(const PyObject* pyObj);

private:
    template <bool Repeated>
    void ConvertInt32(const FieldDescriptor* field, const PyObject* value);

    template <bool Repeated>
    void ConvertInt64(const FieldDescriptor* field, const PyObject* value);

    template <bool Repeated>
    void ConvertUInt32(const FieldDescriptor* field, const PyObject* value);

    template <bool Repeated>
    void ConvertUInt64(const FieldDescriptor* field, const PyObject* value);

    template <bool Repeated>
    void ConvertFloat(const FieldDescriptor* field, const PyObject* value);

    template <bool Repeated>
    void ConvertDouble(const FieldDescriptor* field, const PyObject* value);

    template <bool Repeated>
    void ConvertEnum(const FieldDescriptor* field, const PyObject* value);

    template <bool Repeated>
    void ConvertBool(const FieldDescriptor* field, const PyObject* value);

    template <bool Repeated>
    void ConvertString(const FieldDescriptor* field, const PyObject* value);

    template <bool Repeated>
    void ConvertMsg(const FieldDescriptor* field, const PyObject* value);

    void ConvertMapEntry(
            const FieldDescriptor* field,
            TStringBuf name, TStringBuf value);

private:
    google::protobuf::Message* Message_;
    const google::protobuf::Descriptor* Descr_;
    const google::protobuf::Reflection* Reflection_;
};

} // namespace NPython2

#define INCLUDE_CAST_PROTO_INL_H
#include "cast_proto_inl.h"
#undef INCLUDE_CAST_PROTO_INL_H
