#pragma once

#include "py_string.h"

#include <util/generic/string.h>
#include <util/generic/yexception.h>

#include <Python.h>

#define PY_ENSURE(CONDITION, MESSAGE) \
    Y_ENSURE_EX(CONDITION, ::NPython2::TRuntimeError() << MESSAGE)

#define PY_FAIL(MESSAGE) Y_ENSURE(false, MESSAGE)

#define PY_ENSURE_TYPE(TYPE_CHECK, OBJECT, MESSAGE) Y_ENSURE_EX(\
    TYPE_CHECK(OBJECT), \
    ::NPython2::TRuntimeError() \
        << MESSAGE \
        << ", but got: " << ::NPython2::TypeName(OBJECT))

#define PY_TRY try

#define PY_CATCH(ERROR_VALUE) \
    catch (const yexception& e) { \
        PyErr_SetString(PyExc_RuntimeError, e.what()); \
        return ERROR_VALUE; \
    } catch (...) { \
        TString message = CurrentExceptionMessage(); \
        PyErr_SetString(PyExc_RuntimeError, message.c_str()); \
        return ERROR_VALUE; \
    }


namespace NPython2 {

class TRuntimeError: public yexception {
};

TString LastErrorAsString();

} // namespace NPython2
