#pragma once

#include <util/generic/noncopyable.h>

#include <Python.h>

namespace NPython2 {

///////////////////////////////////////////////////////////////////////////////
// TPyGilGuard
///////////////////////////////////////////////////////////////////////////////
struct TGilGuard: private TNonCopyable {
    TGilGuard()
        : State_(PyGILState_Ensure())
    {
    }

    ~TGilGuard() {
        PyGILState_Release(State_);
    }

private:
    PyGILState_STATE State_;
};

///////////////////////////////////////////////////////////////////////////////
// TPyGilUnguard
///////////////////////////////////////////////////////////////////////////////
struct TGilUnguard: private TNonCopyable {
    TGilUnguard()
        : State_(PyEval_SaveThread())
    {
    }

    ~TGilUnguard() {
        PyEval_RestoreThread(State_);
    }

private:
    PyThreadState* State_;
};

} // namespace NPython2
