#pragma once

#include <library/cpp/monlib/metrics/metric_registry.h>

#include <util/generic/ptr.h>
#include <util/generic/noncopyable.h>

#include <Python.h>

namespace NPython2 {

struct TGilUnguard;

struct TAllocContext {
    PyMemAllocator OriginalAlloc;
    NMonitoring::TIntGauge* AllocatedBytesPerDomain;
    PyMemAllocator Allocator;
};

class TInitializer: private TNonCopyable {
public:
    ~TInitializer();

    static TInitializer* Instance();

private:
    Y_DECLARE_SINGLETON_FRIEND();

    TInitializer();

private:
    THolder<TGilUnguard> Unguard_;

    TAllocContext AllocatorRaw_;
    TAllocContext AllocatorMem_;
    TAllocContext AllocatorObj_;

    NMonitoring::TMetricRegistry* Registry_;
};

} // namespace NPython2
