#include "logger.h"
#include "gil.h"
#include "py_string.h"

#include <solomon/agent/misc/logger.h>

#define SA_PY_LOG(level) SA_LOG_IMPL( \
    ::NSolomon::NAgent::GetLogger(), \
    ::NSolomon::NAgent::ELogLevel::level, \
    "python2", 0)


namespace NPython2 {
namespace {

static PyObject* LoggerRepr(PyObject* self) {
    return PyString_FromFormat("<solomon.Logger object at %p>", self);
}

static void LoggerDealloc(PyObject*) {
    Py_FatalError("deallocating solomon.Logger");
}

static PyObject* LoggerTrace(PyObject* /*self*/, PyObject* string) {
    TStringBuf strBuf = ToStringBufNoAlloc(string);
    {
        TGilUnguard gil;
        SA_PY_LOG(TRACE) << strBuf;
    }

    Py_RETURN_NONE;
}

static PyObject* LoggerDebug(PyObject* /*self*/, PyObject* string) {
    TStringBuf strBuf = ToStringBufNoAlloc(string);
    {
        TGilUnguard gil;
        SA_PY_LOG(DEBUG) << strBuf;
    }

    Py_RETURN_NONE;
}

static PyObject* LoggerInfo(PyObject* /*self*/, PyObject* string) {
    TStringBuf strBuf = ToStringBufNoAlloc(string);
    {
        TGilUnguard gil;
        SA_PY_LOG(INFO) << strBuf;
    }

    Py_RETURN_NONE;
}

static PyObject* LoggerWarn(PyObject* /*self*/, PyObject* string) {
    TStringBuf strBuf = ToStringBufNoAlloc(string);
    {
        TGilUnguard gil;
        SA_PY_LOG(WARN) << strBuf;
    }

    Py_RETURN_NONE;
}

static PyObject* LoggerError(PyObject* /*self*/, PyObject* string) {
    TStringBuf strBuf = ToStringBufNoAlloc(string);
    {
        TGilUnguard gil;
        SA_PY_LOG(ERROR) << strBuf;
    }

    Py_RETURN_NONE;
}

static PyObject* LoggerFatal(PyObject* /*self*/, PyObject* string) {
    TStringBuf strBuf = ToStringBufNoAlloc(string);
    {
        TGilUnguard gil;
        SA_PY_LOG(FATAL) << strBuf;
    }

    Py_RETURN_NONE;
}

PyDoc_STRVAR(PyLogger_Doc,
    "TODO: add solomon.Logger docs");
PyDoc_STRVAR(PyLoggerTrace_Doc,
    "TODO: add solomon.Logger::trace(string) docs");
PyDoc_STRVAR(PyLoggerDebug_Doc,
    "TODO: add solomon.Logger::debug(string) docs");
PyDoc_STRVAR(PyLoggerInfo_Doc,
    "TODO: add solomon.Logger::info(string) docs");
PyDoc_STRVAR(PyLoggerWarn_Doc,
    "TODO: add solomon.Logger::warn(string) docs");
PyDoc_STRVAR(PyLoggerError_Doc,
    "TODO: add solomon.Logger::error(string) docs");
PyDoc_STRVAR(PyLoggerFatal_Doc,
    "TODO: add solomon.Logger::fatal(string) docs");

static PyMethodDef PyLoggerMethods[] = {
    { "trace",  LoggerTrace, METH_O, PyLoggerTrace_Doc },
    { "debug",  LoggerDebug, METH_O, PyLoggerDebug_Doc },
    { "info",  LoggerInfo, METH_O, PyLoggerInfo_Doc },
    { "warn",  LoggerWarn, METH_O, PyLoggerWarn_Doc },
    { "error",  LoggerError, METH_O, PyLoggerError_Doc },
    { "fatal",  LoggerFatal, METH_O, PyLoggerFatal_Doc },
    { nullptr, nullptr, 0, nullptr }    /* sentinel */
};

} // namespace

PyTypeObject PyLoggerType = {
    PyVarObject_HEAD_INIT(&PyType_Type, 0)
    /* tp_name           */ "solomon.Logger",
    /* tp_basicsize      */ 0,
    /* tp_itemsize       */ 0,
    /* tp_dealloc        */ LoggerDealloc,
    /* tp_print          */ nullptr,
    /* tp_getattr        */ nullptr,
    /* tp_setattr        */ nullptr,
    /* tp_compare        */ nullptr,
    /* tp_repr           */ LoggerRepr,
    /* tp_as_number      */ nullptr,
    /* tp_as_sequence    */ nullptr,
    /* tp_as_mapping     */ nullptr,
    /* tp_hash           */ nullptr,
    /* tp_call           */ nullptr,
    /* tp_str            */ nullptr,
    /* tp_getattro       */ PyObject_GenericGetAttr,
    /* tp_setattro       */ nullptr,
    /* tp_as_buffer      */ nullptr,
    /* tp_flags          */ 0,
    /* tp_doc            */ PyLogger_Doc,
    /* tp_traverse       */ nullptr,
    /* tp_clear          */ nullptr,
    /* tp_richcompare    */ nullptr,
    /* tp_weaklistoffset */ 0,
    /* tp_iter           */ nullptr,
    /* tp_iternext       */ nullptr,
    /* tp_methods        */ PyLoggerMethods,
    /* tp_members        */ nullptr,
    /* tp_getset         */ nullptr,
    /* tp_base           */ nullptr,
    /* tp_dict           */ nullptr,
    /* tp_descr_get      */ nullptr,
    /* tp_descr_set      */ nullptr,
    /* tp_dictoffset     */ 0,
    /* tp_init           */ nullptr,
    /* tp_alloc          */ nullptr,
    /* tp_new            */ nullptr,
    /* tp_free           */ nullptr,
    /* tp_is_gc          */ nullptr,
    /* tp_bases          */ nullptr,
    /* tp_mro            */ nullptr,
    /* tp_cache          */ nullptr,
    /* tp_subclasses     */ nullptr,
    /* tp_weaklist       */ nullptr,
    /* tp_del            */ nullptr,
    /* tp_version_tag    */ 0,
};

PyObject PyLoggerObject = {
    PyObject_HEAD_INIT(&PyLoggerType)
};

TObjectPtr GetLogger() {
    return TObjectPtr(&PyLoggerObject, TObjectPtr::ADD_REF);
}

} // namespace NPython2
