#include "py_string.h"

#include <solomon/agent/lib/python2/error.h>

#include <Python.h>

namespace NPython2 {

TString TypeName(const PyObject* o) {
    if (o == nullptr) {
        return "null";
    }

    return o->ob_type->tp_name;
}

// TODO: implement Repr() and Str()

TStringBuf ToStringBufNoAlloc(const PyObject* o) {
    char* str = nullptr;
    Py_ssize_t len = 0;
    if (PyString_AsStringAndSize(const_cast<PyObject*>(o), &str, &len) == -1) {
        ythrow NPython2::TRuntimeError() << NPython2::LastErrorAsString();
    }
    return { str, static_cast<size_t>(len) };
}

} // namespace NPython2
