#pragma once

// XXX: name of this file has prefix py_ because of broken
//      build dependencies graph builder

#include "ptr.h"

#include <util/generic/string.h>

#include <Python.h>

namespace NPython2 {

TString TypeName(const PyObject* o);

TString Repr(const PyObject* o);
TString Str(const PyObject* o);

TStringBuf ToStringBufNoAlloc(const PyObject* o);

template <typename TStringType>
TObjectPtr ToPyString(const TStringType& str) {
    return PyString_FromStringAndSize(str.data(), str.size());
}

} // namespace NPython2
