#include "config_page.h"

/* #include <library/cpp/monlib/encode/format.h> */

/* #include <util/generic/maybe.h> */
#include <util/string/split.h>

#include <google/protobuf/text_format.h>

using namespace NMonitoring;

namespace NSolomon {
namespace NAgent {

TConfigPage::TConfigPage(const TAgentConfig& config)
    : TPreMonPage{"config", "Config", false}
    , Config_{config}
{
}

void TConfigPage::OutputProto(NMonitoring::IMonHttpRequest& request) {
    request.Output().Write(HTTPOKTEXT);

    TString configStr;
    ::google::protobuf::TextFormat::PrintToString(Config_, &configStr);

    request.Output() << configStr;
}

void TConfigPage::OutputText(IOutputStream& os, NMonitoring::IMonHttpRequest&) {
    TString configStr;
    ::google::protobuf::TextFormat::PrintToString(Config_, &configStr);

    HTML(os) {
        PRE() {
            os << configStr;
        }
    }
}

void TConfigPage::Output(NMonitoring::IMonHttpRequest& request) {
    TVector<TStringBuf> parts;
    StringSplitter(request.GetPathInfo()).Split('/').SkipEmpty().Collect(&parts);

    if (parts.empty()) {
        TPreMonPage::Output(request);
    } else if (parts.back() == "plain") {
        OutputProto(request);
    } else {
        NotFound(request);
    }
}

} // namespace NAgent
} // namespace NSolomon
