#include "service.h"

#include <solomon/agent/lib/thread/pool_provider.h>
#include <solomon/agent/misc/logger.h>
#include <solomon/agent/protos/management_server_config.pb.h>

#include <library/cpp/monlib/metrics/metric_registry.h>
#include <library/cpp/monlib/service/monservice.h>

#include <library/cpp/monlib/service/pages/version_mon_page.h>
#include <library/cpp/monlib/service/pages/registry_mon_page.h>

namespace NSolomon {
namespace NAgent {

using namespace NMonitoring;


TMonService::TMonService(const TManagementServerConfig& config, IThreadPoolProvider& threadPoolProvider) {
    Port_ = config.GetBindPort();
    const auto address = config.GetBindAddress();

    Y_VERIFY(Port_ <= std::numeric_limits<ui16>::max());

    auto opts = THttpServerOptions{static_cast<ui16>(Port_)}
        .AddBindAddress(address);

    const TString& poolName = config.GetThreadPoolName();
    auto poolPtr = poolName
        ? threadPoolProvider.GetThreadPool(poolName)
        : threadPoolProvider.GetDefaultPool();

    Impl_.Reset(new NMonitoring::TMonService2{opts, std::move(poolPtr)});

    auto* registry = NMonitoring::TMetricRegistry::Instance();
    AddPage(new TMetricRegistryPage{"counters", "Counters", registry});
    AddPage(new TVersionMonPage);
}

void TMonService::AddPage(TIntrusivePtr<NMonitoring::IMonPage> page) {
    Impl_->Register(std::move(page));
}

void TMonService::Start() {
    try {
        Impl_->StartOrThrow();
        SA_LOG(INFO) << "management server started on port " << Port_;
    } catch (...) {
        SA_LOG(ERROR) << "Unable to start management service on port " << Port_
            << " :" << CurrentExceptionMessage();
            throw;
    }
}

TMonService::~TMonService() = default;

} // NAgent
} // NSolomon
