#pragma once

#include <solomon/agent/lib/thread/pool_provider.h>

#include <util/generic/ptr.h>
#include <util/generic/hash.h>
#include <util/thread/factory.h>

namespace NMonitoring {
    class TMonService2;
    class IMonPage;
}

namespace NSolomon {
namespace NAgent {

class TManagementServerConfig;

class TMonService final {
public:
    TMonService(const TManagementServerConfig&, IThreadPoolProvider& threadPoolProvider);
    ~TMonService();

    /// @throws TSystemError if failed while starting server
    void Start();

    void AddPage(TIntrusivePtr<NMonitoring::IMonPage> page);

private:
    THolder<NMonitoring::TMonService2> Impl_;
    ui32 Port_ {0};
};

} // NAgent
} // NSolomon
