#pragma once

#include <solomon/agent/misc/task_state.h>

#include <library/cpp/monlib/metrics/fwd.h>

#include <util/datetime/base.h>
#include <util/generic/maybe.h>
#include <util/generic/hash.h>
#include <util/system/spinlock.h>

namespace NSolomon {
namespace NAgent {

struct TModuleStatus {
    TString Name;
    TDuration Interval;
    int ReturnValue;
    TMaybe<TString> ErrorMessage;
    TInstant Timestamp;
    TDuration ExecTime;
    TTaskState::EState SchedulerState;
};

class TPullerStatus {
private:
    TAdaptiveLock Lock_;
    THashMap<TString, TModuleStatus> ModulesStatus_;

    NMonitoring::TMetricRegistry& Registry_;

public:
    explicit TPullerStatus(NMonitoring::TMetricRegistry& registry);

    void UpdateModuleData(TModuleStatus data) noexcept;
    void UpdateModuleDataOnSkip(TStringBuf name, TDuration waitTime) noexcept;

    void UpdateModuleState(TStringBuf name, TTaskState::EState state) noexcept;
    void RemoveModuleData(TStringBuf name);

    void ForEachModule(const std::function<void(const TModuleStatus&)>& fn) const;
};

} // namespace NAgent
} // namespace NSolomon
