#pragma once

#include <solomon/agent/lib/http/server.h>
#include <solomon/agent/lib/pusher/pusher.h>
#include <solomon/agent/lib/storage/memory_usage.h>
#include <solomon/agent/lib/storage/storage.h>

#include <solomon/libs/cpp/threading/pool/pool.h>

#include <library/cpp/http/misc/httpcodes.h>
#include <library/cpp/monlib/metrics/fwd.h>

#include <util/datetime/base.h>
#include <util/generic/ptr.h>

namespace NSolomon {
namespace NAgent {

THolder<class TBackgroundThreads> CreateProcessMonitoringThread(NMonitoring::TMetricRegistry& registry);

IServerStatusListenerPtr CreateServerStatusListener(
        NMonitoring::TMetricRegistry&,
        NMonitoring::TLabels additionalLabels);

IThreadPoolStatusListenerPtr CreateThreadPoolStatusListener(
        TString poolName,
        NMonitoring::TMetricRegistry& metricRegistry,
        NMonitoring::TLabels additionalLabels);

IDataPusherStatusListenerPtr CreateDataPusherStatusListener(
        NMonitoring::TMetricRegistry& metricRegistry,
        NMonitoring::TLabels additionalLabels);

IStorageUpdateListenerPtr CreateStorageShardUpdateListener(
        const TStorageShardId& shardId,
        NMonitoring::TMetricRegistry& registry);

IMemoryUsageInfoListenerPtr CreateMemoryUsageInfoListener(NMonitoring::TMetricRegistry& metricRegistry);

} // namespace NAgent
} // namespace NSolomon
