#include <solomon/agent/lib/storage/common.h>

#include <library/cpp/testing/gtest/gtest.h>

using namespace NSolomon;
using namespace NAgent;

TEST(TParseHumanReadableSizeTest, WithoutMultiple) {
    ASSERT_EQ(ParseHumanReadableSize("123456789"), 123456789u);
}

TEST(TParseHumanReadableSizeTest, WithMultiple) {
    ASSERT_EQ(ParseHumanReadableSize("123456789B"), 123456789u);
    ASSERT_EQ(ParseHumanReadableSize("789KiB"), 789u << 10);
    ASSERT_EQ(ParseHumanReadableSize("173MiB"), 173u << 20);
    ASSERT_EQ(ParseHumanReadableSize("2GiB"), 2ull << 30);
}

TEST(TParseHumanReadableSizeTest, ShortString) {
    ASSERT_EQ(ParseHumanReadableSize("1"), 1u);
    ASSERT_EQ(ParseHumanReadableSize("1B"), 1u);
    ASSERT_EQ(ParseHumanReadableSize("1KiB"), 1ull << 10);
    ASSERT_EQ(ParseHumanReadableSize("1MiB"), 1ull << 20);
    ASSERT_EQ(ParseHumanReadableSize("1GiB"), 1ull << 30);
}

TEST(TParseHumanReadableSizeTest, WrongFormat) {
    ASSERT_THROW(ParseHumanReadableSize("123YiB"), yexception);
    ASSERT_THROW(ParseHumanReadableSize("only_text"), yexception);
    ASSERT_THROW(ParseHumanReadableSize("mixed123mixed"), yexception);
    ASSERT_THROW(ParseHumanReadableSize("123mixed123"), yexception);
}
