#pragma once

#include <solomon/agent/lib/consumers/transforming_consumer.h>
#include <solomon/agent/lib/storage/storage.h>

namespace NSolomon::NAgent {

class TTransformingStorage: public IStorage {
    class TTransformingStorageConsumer: public IStorageMetricsConsumer {
    public:
        TTransformingStorageConsumer(IStorageMetricsConsumer* storageConsumer, IMetricConsumer* transformingConsumer)
            : StorageConsumer_{storageConsumer}
            , TransformingConsumer_{transformingConsumer}
        {
        }

        void Flush() override {
            StorageConsumer_->Flush();
        }

        // Proxying
        void OnStreamBegin() override {
            TransformingConsumer_->OnStreamBegin();
        }
        void OnStreamEnd() override {
            TransformingConsumer_->OnStreamEnd();
        }

        void OnCommonTime(TInstant time) override {
            TransformingConsumer_->OnCommonTime(time);
        }

        void OnMetricBegin(NMonitoring::EMetricType type) override {
            TransformingConsumer_->OnMetricBegin(type);
        }
        void OnMetricEnd() override {
            TransformingConsumer_->OnMetricEnd();
        }

        void OnLabelsBegin() override {
            TransformingConsumer_->OnLabelsBegin();
        }
        void OnLabelsEnd() override {
            TransformingConsumer_->OnLabelsEnd();
        }
        void OnLabel(TStringBuf name, TStringBuf value) override {
            TransformingConsumer_->OnLabel(name, value);
        }

        void OnDouble(TInstant time, double value) override {
            TransformingConsumer_->OnDouble(time, value);
        }
        void OnInt64(TInstant time, i64 value) override {
            TransformingConsumer_->OnInt64(time, value);
        }
        void OnUint64(TInstant time, ui64 value) override {
            TransformingConsumer_->OnUint64(time, value);
        }
        void OnHistogram(TInstant time, NMonitoring::IHistogramSnapshotPtr snapshot) override {
            TransformingConsumer_->OnHistogram(time, std::move(snapshot));
        }

        void OnSummaryDouble(TInstant time, NMonitoring::ISummaryDoubleSnapshotPtr snapshot) override {
            TransformingConsumer_->OnSummaryDouble(time, std::move(snapshot));
        }

        void OnLogHistogram(TInstant time, NMonitoring::TLogHistogramSnapshotPtr snapshot) override {
            TransformingConsumer_->OnLogHistogram(time, std::move(snapshot));
        }

    private:
        IStorageMetricsConsumer* StorageConsumer_;
        IMetricConsumer* TransformingConsumer_;
    };

public:
    TTransformingStorage(ui32 bufferSize)
            : InnerStorage_{CreateMemStorage({"project", "service"}, MAX_STORAGE_LIMIT, bufferSize)}
    // no transformations are specified
    {
        // A rule that doesn't change anything
        Config_.AddRule()->SetReplaceMeta("someNonExistentLabel=-");
        TransformingConsumer_ = CreateTransformingConsumer(&Config_);
    }

    TReadResult Read(const TQuery& query, NMonitoring::IMetricConsumer* c, const TReadOptions& options = {}) override {
        return InnerStorage_->Read(query, c, options);
    }

    TFindResult Find(const TQuery& query, NMonitoring::IMetricConsumer* c,  const TFindOptions& options = {}) override {
        return InnerStorage_->Find(query, c, options);
    }

    IStorageMetricsConsumerPtr CreateConsumer(TInstant) override {
        StorageConsumer_ = InnerStorage_->CreateConsumer();
        TransformingConsumer_->SetInnerConsumer(StorageConsumer_.Get());
        return MakeHolder<TTransformingStorageConsumer>(StorageConsumer_.Get(), TransformingConsumer_.Get());
    }

    void Delete(const TQuery& query, const TDeleteOptions& options = TDeleteOptions()) override {
        InnerStorage_->Delete(query, options);
    }

    void Commit(const TString& consumerId, TSeqNo seqNo) override {
        InnerStorage_->Commit(consumerId, seqNo);
    }

private:
    IStoragePtr InnerStorage_;
    ITransformingConsumerPtr TransformingConsumer_;
    IStorageMetricsConsumerPtr StorageConsumer_;
    TTransformationsConfig Config_;
};

} // namespace NSolomon::NAgent
