#pragma once

#include <solomon/agent/protos/thread_pools_config.pb.h>

#include <solomon/libs/cpp/threading/pool/pool.h>

#include <library/cpp/monlib/metrics/metric_registry.h>

#include <util/generic/hash.h>
#include <util/generic/ptr.h>
#include <util/system/spinlock.h>
#include <util/thread/factory.h>
#include <util/thread/pool.h>

namespace NSolomon::NAgent {

class IThreadPoolProvider {

public:
    virtual ~IThreadPoolProvider() = default;

    virtual TSimpleSharedPtr<IThreadPool> GetThreadPool(TStringBuf poolName) = 0;
    virtual TSimpleSharedPtr<IThreadPool> GetDefaultPool() = 0;

    virtual TSimpleSharedPtr<IThreadPool> operator[](TStringBuf poolName) = 0;
};

using IThreadPoolProviderPtr = TAtomicSharedPtr<IThreadPoolProvider>;

using TThreadPoolStatusListenerFactory = std::function<IThreadPoolStatusListenerPtr(
        TString poolName,
        NMonitoring::TLabels)>;

IThreadPoolProviderPtr CreateLazyThreadPoolProvider(
        const TThreadPoolProviderConfig& config,
        TThreadPoolStatusListenerFactory listenerFactory = nullptr);

IThreadPoolProviderPtr CreateLazyThreadPoolProvider(TThreadPoolStatusListenerFactory listenerFactory = nullptr);

TSimpleSharedPtr<IThreadPool> CreateThreadPool(
        size_t threadsCount,
        size_t queueSizeLimit,
        IThreadPoolStatusListenerPtr statusListener);

} // namespace NSolomon::NAgent
