#pragma once

#include <solomon/libs/cpp/threading/pool/pool.h>

#include <util/thread/pool.h>

namespace NSolomon::NAgent {

// NSolomon::CreateThreadPool() does the same with a custom shared_ptr::Deleter, but
// inside Agent a lot of components wait for TSimpleSharedPtr<IThreadPool>, so we have to create another wrapper
// for interface compatibility :(
class TThreadPoolProxyWithImplementationOwning: public IThreadPool {
public:
    TThreadPoolProxyWithImplementationOwning(
            size_t threadCount,
            size_t queueSizeLimit,
            IThreadPoolStatusListenerPtr statusListener = nullptr)
        : Pool_{::TThreadPool::TParams().SetBlocking(false).SetCatching(true)}
        , Proxy_{CreateThreadPoolProxy(&Pool_, std::move(statusListener))}
    {
        Pool_.Start(threadCount, queueSizeLimit);
    }

    bool Add(IObjectInQueue* obj) override {
        return Proxy_->Add(obj);
    }

    void Start(size_t, size_t) override {
    }

    void Stop() noexcept override {
    }

    size_t Size() const noexcept override {
            return Proxy_->Size();
    }

    void* CreateThreadSpecificResource() override {
        return Proxy_->CreateThreadSpecificResource();
    }

    void DestroyThreadSpecificResource(void* resource) override {
        Proxy_->DestroyThreadSpecificResource(resource);
    }

    TThreadPool& InternalPool() {
        return Pool_;
    }

private:
    TThreadPool Pool_;
    std::shared_ptr<IThreadPool> Proxy_;
};

} // namespace NSolomon::NAgent
