#pragma once

#include <functional>
#include <thread>

#include <library/cpp/deprecated/atomic/atomic.h>
#include <util/generic/vector.h>
#include <util/datetime/base.h>
#include <util/generic/noncopyable.h>

namespace NSolomon {
namespace NAgent {

class TBackgroundThreads: private TNonCopyable {
    // returns duration to sleep before next iteration.
    // you can return TDuration::Max() if it is needed to break execution
    using TCallable = std::function<TDuration()>;

public:
    TBackgroundThreads();
    virtual ~TBackgroundThreads();

    void Stop();

    void RunInBackground(
            TStringBuf threadName,
            TCallable callable,
            TDuration initialSleep = TDuration::Zero());

    size_t Size() const {
        return Threads_.size();
    }

private:
    void ExecuteInLoop(
            TStringBuf threadName,
            const TCallable& callable,
            TDuration initialSleep) const;

    void IncrementalSleep(TDuration amount) const;

private:
    std::atomic<bool> KeepRunning_;
    TVector<std::thread> Threads_;
};

} // namespace NAgent
} // namespace NSolomon
