#include "labels.h"

#include <util/generic/algorithm.h>

namespace NSolomon::NAgent {

    void TSortableLabels::Sort() {
        ::Sort(AsVector(), [](const TAgentLabel& left, const TAgentLabel& right) {
            if (left.Name() < right.Name()) {
                return true;
            } else if (left.Name() > right.Name()) {
                return false;
            } else {
                return left.Value() < right.Value();
            }
        });
    }

}

Y_MONLIB_DEFINE_LABELS_OUT(NSolomon::NAgent::TAgentLabels);
