#pragma once

#include <library/cpp/monlib/metrics/labels.h>

#include <string>

namespace NSolomon::NAgent {
    using TLabelBackend = std::string;

    class TSortableLabels: public NMonitoring::TLabelsImpl<TLabelBackend> {
    public:
        using TBase = NMonitoring::TLabelsImpl<TLabelBackend>;
        using TBase::TBase;

        void Sort();
    };

    using TAgentLabel = NMonitoring::TLabelImpl<TLabelBackend>;
    using TAgentLabels = TSortableLabels;

    using TLabel = TAgentLabel;
    using TLabels = TAgentLabels;
}

template <>
struct THash<NSolomon::NAgent::TAgentLabels> {
    size_t operator()(const NSolomon::NAgent::TAgentLabels& labels) const noexcept {
        return static_cast<NMonitoring::TLabelsImpl<NSolomon::NAgent::TLabelBackend>>(labels).Hash();
    }
};
