#pragma once

#include "labels.h"

#include <functional>

namespace NSolomon::NAgent {
    enum class EMatchType {
        EXACT,
        PREFIX,
        CONTAINS,
        GLOB,
        REGEXP,
    };

    EMatchType MatchTypeFromStr(TStringBuf str);
    TStringBuf MatchTypeToStr(EMatchType type);

    /**
     * optionalLabels are additional labels to search a value in. Sometimes CommonLabels are present, sometimes they
     * are not, so they are optional.
     */
    bool MatchExact(const NMonitoring::ILabels& pattern,
                    const NMonitoring::ILabels& labels, const NMonitoring::ILabels* optionalLabels = nullptr);

    bool MatchPrefix(const NMonitoring::ILabels& pattern,
                     const NMonitoring::ILabels& labels, const NMonitoring::ILabels* optionalLabels = nullptr);

    bool MatchContains(const NMonitoring::ILabels& pattern,
                       const NMonitoring::ILabels& labels, const NMonitoring::ILabels* optionalLabels = nullptr);

    bool MatchGlob(const NMonitoring::ILabels& pattern,
                   const NMonitoring::ILabels& labels, const NMonitoring::ILabels* optionalLabels = nullptr);

    bool MatchRegExp(const NMonitoring::ILabels& pattern,
                     const NMonitoring::ILabels& labels, const NMonitoring::ILabels* optionalLabels = nullptr);

    using TLabelsMatcher = std::function<bool(const NMonitoring::ILabels&, const NMonitoring::ILabels* /*optionalLabels*/)>;

    TLabelsMatcher CreateMatcher(EMatchType matchType, const NMonitoring::ILabels& pattern);

}
