#include "labels_merge.h"

namespace NSolomon::NAgent {

    void PerformOnMergedLabels(const TLabels& usualLabels, const TLabels& commonLabels, TAction action) {
        auto uIt = usualLabels.begin();
        auto cIt = commonLabels.begin();

        while (uIt != usualLabels.end() && cIt != commonLabels.end()) {
            if (uIt->Name() == cIt->Name()) {
                // choosing a usual label instead of a common one
                action(*uIt);
                ++cIt;
                ++uIt;
            } else {
                if (uIt->Name() < cIt->Name()) {
                    action(*uIt);
                    ++uIt;
                } else {
                    action(*cIt);
                    ++cIt;
                }
            }
        }

        while (uIt != usualLabels.end()) {
            action(*uIt);
            ++uIt;
        }

        while (cIt != commonLabels.end()) {
            action(*cIt);
            ++cIt;
        }
    }

    TLabels MergeSortedUsualAndCommonLabels(const TLabels& usualLabels, const TLabels& commonLabels) {
        TLabels resultLabels;

        PerformOnMergedLabels(usualLabels, commonLabels, [&resultLabels](const NMonitoring::ILabel& label) {
            resultLabels.Add(label);
        });

        return resultLabels;
    }

    TLabels MergeUsualAndCommonLabels(TLabels usualLabels, TLabels commonLabels) {
        usualLabels.Sort();
        commonLabels.Sort();

        return MergeSortedUsualAndCommonLabels(usualLabels, commonLabels);
    }

} // namespace NSolomon::NAgent
