#pragma once

#include <library/cpp/logger/log.h>
#include <library/cpp/monlib/metrics/metric_registry.h>
#include <library/cpp/monlib/metrics/metric.h>

#include <util/generic/ptr.h>
#include <util/generic/vector.h>

#define SA_LOG_IMPL(logger, level, file, line) \
    logger.NeedToLog(level) && ::NSolomon::NAgent::TSolomonLog::TEatStream() | \
        (*logger.CreateLogElement(level, file, line))

#define SA_LOG(level) SA_LOG_IMPL( \
    ::NSolomon::NAgent::GetLogger(), \
    ::NSolomon::NAgent::ELogLevel::level, \
    __FILE__, __LINE__)


namespace NSolomon {
namespace NAgent {

class TLoggerConfig;

enum class ELogLevel {
    FATAL,
    ERROR,
    WARN,
    INFO,
    DEBUG,
    TRACE,
};

class TSolomonLog: public TLog {
public:
    struct TEatStream {
        Y_FORCE_INLINE bool operator|(const IOutputStream&) const {
            return true;
        }
    };

public:
    TSolomonLog();
    TSolomonLog(THolder<TLogBackend> backend);

    void EnableEntryCounting(NMonitoring::TMetricRegistry* metricRegistry);

    inline bool NeedToLog(ELogLevel level) const noexcept {
        return static_cast<int>(level) <= static_cast<int>(Level_);
    }

    inline void SetCurrentLevel(ELogLevel level) noexcept {
        Level_ = level;
    }

    THolder<TLogElement> CreateLogElement(
            ELogLevel level, const char* file, int line);

private:
    ELogLevel Level_;
    NMonitoring::TMetricRegistry* Registry_;
    TVector<NMonitoring::IRate*> LevelMetrics_;
};

inline TSolomonLog& GetLogger() {
    static TSolomonLog logger;
    return logger;
}

void InitLogger(
        const TLoggerConfig& config,
        NMonitoring::TMetricRegistry* metricRegistry = nullptr);
void InitLogger(
        IOutputStream* out,
        NMonitoring::TMetricRegistry* metricRegistry = nullptr);

} // namespace NAgent
} // namespace NSolomon
