#pragma once

//
// States transition:
//
//   VIRGIN -> SCHEDULED -> EXECUTED
//         \       |       /
//          \      |      /
//           v     v     v
//             CANCELLED
//

struct TTaskState {
    enum EState {
        VIRGIN /* "Virgin" */,        // task has not yet been scheduled
        SCHEDULED /* "Scheduled" */,  // task is scheduled for execution, if it is a
                                      // non-repeating task, it has not yet been executed
        EXECUTED /* "Executed" */,    // non-repeating task has already executed (or is currently
                                      // executing) and has not been cancelled
        CANCELLED /* "Cancelled" */,    // task has been cancelled
    };
};
