#include <solomon/agent/misc/enum_define.h>

#include <library/cpp/testing/gtest/gtest.h>

ENUM_DEFINE(EColor,
    RED,
    GREEN,
    BLUE);

ENUM_DEFINE(EStatus,
    OPENED,
    CLOSED);

TEST(TEnumDefineTest, Size) {
    ASSERT_EQ(TEnumInfo<EColor>::Size(), 3u);
    ASSERT_EQ(TEnumInfo<EStatus>::Size(), 2u);
}

TEST(TEnumDefineTest, ToString) {
    ASSERT_EQ(TEnumInfo<EColor>::ToString(EColor::RED), "RED");
    ASSERT_EQ(TEnumInfo<EColor>::ToString(EColor::GREEN), "GREEN");
    ASSERT_EQ(TEnumInfo<EColor>::ToString(EColor::BLUE), "BLUE");
}

TEST(TEnumDefineTest, FromString) {
    ASSERT_EQ(TEnumInfo<EColor>::FromString("RED"), EColor::RED);
    ASSERT_EQ(TEnumInfo<EColor>::FromString("GREEN"), EColor::GREEN);
    ASSERT_EQ(TEnumInfo<EColor>::FromString("BLUE"), EColor::BLUE);

    ASSERT_THROW_MESSAGE_HAS_SUBSTR(
            TEnumInfo<EColor>::FromString("PINK"),
            yexception,
            "Unknown enum value: PINK");
}

TEST(TEnumDefineTest, Values) {
    ui32 index = 0;
    for (EColor color: TEnumInfo<EColor>::Values()) {
        switch (index) {
        case 0:
            ASSERT_EQ(color, EColor::RED);
            break;
        case 1:
            ASSERT_EQ(color, EColor::GREEN);
            break;
        case 2:
            ASSERT_EQ(color, EColor::BLUE);
            break;
        default:
            FAIL() << "invalid index";
        }
        ++index;
    }
}

TEST(TEnumDefineTest, ValuesStr) {
    ui32 index = 0;
    for (TStringBuf name: TEnumInfo<EColor>::ValuesStr()) {
        switch (index) {
        case 0:
            ASSERT_EQ(name, "RED");
            break;
        case 1:
            ASSERT_EQ(name, "GREEN");
            break;
        case 2:
            ASSERT_EQ(name, "BLUE");
            break;
        default:
            FAIL() << "invalid index";
        }
        ++index;
    }
}
