#include <solomon/agent/misc/labels_match.h>

#include <library/cpp/testing/gtest/gtest.h>

using namespace NSolomon::NAgent;

TEST(TLabelsMatchTest, Exact) {
    {
        TLabels l = {{"a", "111"}};
        ASSERT_TRUE(MatchExact(TLabels({{"a", "111"}}), l));
        ASSERT_FALSE(MatchExact(TLabels({{"a", "1"}}), l));
        ASSERT_FALSE(MatchExact(TLabels({{"b", "111"}}), l));
    }
    {
        TLabels l = {{"a", "111"}, {"b", "222"}};
        ASSERT_TRUE(MatchExact(TLabels({{"a", "111"}, {"b", "222"}}), l));
        ASSERT_TRUE(MatchExact(TLabels({{"b", "222"}, {"a", "111"}}), l));
        ASSERT_FALSE(MatchExact(TLabels({{"a", "1"}}), l));
        ASSERT_FALSE(MatchExact(TLabels({{"b", "2"}}), l));
        ASSERT_FALSE(MatchExact(TLabels({{"b", "222"}, {"a", "222"}}), l));
    }
    {
        TLabels l = {{"a", "111"}, {"b", "222"}};
        TLabels commonLabels = {{"commonName", "commonValue"}};

        ASSERT_FALSE(MatchContains(TLabels({{"a", "1"}, {"commonName", "c"}}), l));
        ASSERT_TRUE(MatchContains(TLabels({{"a", "1"}, {"commonName", "commonValue"}}), l, &commonLabels));
    }
}

TEST(TLabelsMatchTest, Contains) {
    {
        TLabels l = {{"a", "111"}};
        ASSERT_TRUE(MatchContains(TLabels({{"a", "1"}}), l));
    }
    {
        TLabels l = {{"a", "111"}, {"b", "222"}};

        ASSERT_TRUE(MatchContains(TLabels({{"a", "1"}}), l));
        ASSERT_TRUE(MatchContains(TLabels({{"b", "2"}, {"a", "1"}}), l));
        ASSERT_FALSE(MatchContains(TLabels({{"a", "2"}}), l));
        ASSERT_FALSE(MatchContains(TLabels({{"b", "1"}}), l));
        ASSERT_FALSE(MatchContains(TLabels({{"c", "2"}, {"a", "1"}}), l));
    }
    {
        TLabels l = {{"a", "111"}, {"b", "222"}};
        TLabels commonLabels = {{"commonName", "commonValue"}};

        ASSERT_FALSE(MatchContains(TLabels({{"a", "1"}, {"commonName", "c"}}), l));
        ASSERT_TRUE(MatchContains(TLabels({{"a", "1"}, {"commonName", "c"}}), l, &commonLabels));
    }
}
