#include <solomon/agent/misc/labels_merge.h>

#include <library/cpp/testing/gtest/gtest.h>

#include <util/string/cast.h>

using namespace NSolomon::NAgent;

TEST(TLabelsMergeTest, Merge) {
    {
        TLabels result = MergeUsualAndCommonLabels({}, {});

        ASSERT_EQ(result.size(), 0u);
    }

    {
        TLabels result = MergeUsualAndCommonLabels(
            {
                {"a", "1"}
            },
            {}
        );

        ASSERT_EQ(result.size(), 1u);

        ASSERT_EQ(result[0].Name(), "a");
        ASSERT_EQ(result[0].Value(), "1");
    }

    {
        TLabels result = MergeUsualAndCommonLabels(
            {},
            {
                {"a", "1"}
            }
        );

        ASSERT_EQ(result.size(), 1u);

        ASSERT_EQ(result[0].Name(), "a");
        ASSERT_EQ(result[0].Value(), "1");
    }

    {
        TLabels result = MergeUsualAndCommonLabels(
            {
                {"label", "usual"}
            },
            {
                {"label", "common"}
            }
        );

        ASSERT_EQ(result.size(), 1u);

        ASSERT_EQ(result[0].Name(), "label");
        ASSERT_EQ(result[0].Value(), "usual");
    }

    {
        TLabels result = MergeUsualAndCommonLabels(
            {
                {"1", "1"},
                {"3", "3"},
                {"5", "5"},
                {"7", "7"},
                {"9", "9"},
            },
            {
                {"2", "2"},
                {"4", "4"},
                {"6", "6"},
                {"8", "8"},
            }
        );

        ASSERT_EQ(result.size(), 9u);

        for (size_t i = 1; i <= 9; ++i) {
            ASSERT_EQ(result[i - 1].Name(), ToString(i));
            ASSERT_EQ(result[i - 1].Value(), ToString(i));
        }
    }

    {
        TLabels result = MergeUsualAndCommonLabels(
            {
                {"1", "1"},
                {"2", "usual 2"},
                {"3", "3"},
                {"4", "usual 4"},
                {"5", "5"},
                {"6", "usual 6"},
                {"7", "7"},
                {"8", "usual 8"},
                {"9", "9"},
            },
            {
                {"2", "common 2"},
                {"4", "common 4"},
                {"6", "common 6"},
                {"8", "common 8"},
            }
        );

        ASSERT_EQ(result.size(), 9u);

        for (size_t i = 1; i <= 9; ++i) {
            ASSERT_EQ(result[i - 1].Name(), ToString(i));
            if (i % 2 == 0) {
                ASSERT_EQ(result[i - 1].Value(), "usual " + ToString(i));
            } else {
                ASSERT_EQ(result[i - 1].Value(), ToString(i));
            }
        }
    }

    {
        TLabels result = MergeUsualAndCommonLabels(
            {
                {"9", "usual 9"},
                {"8", "usual 8"},
                {"7", "usual 7"},
                {"6", "usual 6"},
                {"5", "usual 5"},
                {"4", "usual 4"},
                {"3", "usual 3"},
                {"2", "usual 2"},
                {"1", "usual 1"},
            },
            {
                {"1", "common 1"},
                {"2", "common 2"},
                {"3", "common 3"},
                {"4", "common 4"},
                {"5", "common 5"},
                {"6", "common 6"},
                {"7", "common 7"},
                {"8", "common 8"},
                {"9", "common 9"},
            }
        );

        ASSERT_EQ(result.size(), 9u);

        for (size_t i = 1; i <= 9; ++i) {
            ASSERT_EQ(result[i - 1].Name(), ToString(i));
            ASSERT_EQ(result[i - 1].Value(), "usual " + ToString(i));
        }
    }

    {
        TLabels result = MergeUsualAndCommonLabels(
            {
                {"1", "usual 1"},
                {"9", "usual 9"},
                {"7", "usual 7"},
                {"5", "usual 5"},
                {"3", "usual 3"},
            },
            {
                {"2", "common 2"},
                {"6", "common 6"},
                {"4", "common 4"},
                {"8", "common 8"},
            }
        );

        ASSERT_EQ(result.size(), 9u);

        for (size_t i = 1; i <= 9; ++i) {
            ASSERT_EQ(result[i - 1].Name(), ToString(i));
            if (i % 2 == 0) {
                ASSERT_EQ(result[i - 1].Value(), "common " + ToString(i));
            } else {
                ASSERT_EQ(result[i - 1].Value(), "usual " + ToString(i));
            }
        }
    }
}
