#include <solomon/agent/misc/logger.h>
#include <solomon/agent/misc/logger_test.h>
#include <solomon/agent/misc/logger.h_serialized.h>

#include <library/cpp/testing/gtest/gtest.h>
#include <library/cpp/monlib/metrics/metric_registry.h>
#include <library/cpp/monlib/encode/protobuf/protobuf.h>

#include <util/stream/str.h>
#include <util/string/split.h>
#include <util/generic/ptr.h>

using namespace NSolomon;
using namespace NAgent;

    void PrintMessages() {
        SA_LOG(FATAL) << "fatal message";
        SA_LOG(ERROR) << "error message";
        SA_LOG(WARN) << "warning message";
        SA_LOG(INFO) << "info message";
        SA_LOG(DEBUG) << "debug message";
        SA_LOG(TRACE) << "trace message";
}

TEST(TLoggerTest, Levels) {
    TStringStream out;
    InitLogger(&out); // default level is INFO

    PrintMessages();

    TString fatalStr, errorStr, warnStr, infoStr, _;
    Split(out.Str(), '\n', fatalStr, errorStr, warnStr, infoStr, _);

    {
        TLogRow logRow = ParseLogRow(fatalStr);
        ASSERT_EQ(logRow.Level, ELogLevel::FATAL);
        ASSERT_EQ(logRow.FileName, "logger_ut.cpp");
        ASSERT_TRUE(logRow.LineNumber > 0);
        ASSERT_EQ(logRow.Message, "fatal message");
    }
    {
        TLogRow logRow = ParseLogRow(errorStr);
        ASSERT_EQ(logRow.Level, ELogLevel::ERROR);
        ASSERT_EQ(logRow.FileName, "logger_ut.cpp");
        ASSERT_TRUE(logRow.LineNumber > 0);
        ASSERT_EQ(logRow.Message, "error message");
    }
    {
        TLogRow logRow = ParseLogRow(warnStr);
        ASSERT_EQ(logRow.Level, ELogLevel::WARN);
        ASSERT_EQ(logRow.FileName, "logger_ut.cpp");
        ASSERT_TRUE(logRow.LineNumber > 0);
        ASSERT_EQ(logRow.Message, "warning message");
    }
    {
        TLogRow logRow = ParseLogRow(infoStr);
        ASSERT_EQ(logRow.Level, ELogLevel::INFO);
        ASSERT_EQ(logRow.FileName, "logger_ut.cpp");
        ASSERT_TRUE(logRow.LineNumber > 0);
        ASSERT_EQ(logRow.Message, "info message");
    }
}

TEST(TLoggerTest, Metrics) {
    TStringStream out;
    auto *metricRegistry = NMonitoring::TMetricRegistry::Instance();
    InitLogger(&out, metricRegistry);
    GetLogger().SetCurrentLevel(ELogLevel::TRACE);

    PrintMessages();

    NMonitoring::NProto::TSingleSamplesList samples;
    auto encoder = NMonitoring::EncoderProtobuf(&samples);
    metricRegistry->Accept(TInstant::Zero(), encoder.Get());

    ASSERT_EQ(samples.SamplesSize(), GetEnumItemsCount<ELogLevel>());
    for (const auto& sample: samples.GetSamples()) {
        ASSERT_EQ(sample.LabelsSize(), 2u);
        {
            auto label1 = sample.GetLabels(0);
            ASSERT_EQ(label1.GetName(), "sensor");
            ASSERT_EQ(label1.GetValue(), "logger.entryCount");

            auto label2 = sample.GetLabels(1);
            ASSERT_EQ(label2.GetName(), "logLevel");
        }
        {
            ASSERT_EQ(sample.GetMetricType(), NMonitoring::NProto::RATE);
            ASSERT_EQ(sample.GetUint64(), 1u);
        }
    }
}
