#include "caching_converter.h"

#include <library/cpp/cache/cache.h>

#include <library/cpp/monlib/metrics/labels.h>

#include <util/generic/hash.h>
#include <util/generic/maybe.h>
#include <util/system/spinlock.h>


namespace NSolomon {
namespace NAgent {

class TCachingConverter: public ILabelConverter {
public:
    explicit TCachingConverter(ILabelConverterPtr impl, size_t size)
        : Impl_{std::move(impl)}
        , Cache_{size}
    {
    }

    TMaybe<NMonitoring::TLabels> Convert(TStringBuf foreign) const override {
        auto g = Guard(CacheLock_);

        TString foreignStr{foreign};

        auto it = Cache_.Find(foreignStr);
        if (it != Cache_.End()) {
            return *it;
        }

        TMaybe<NMonitoring::TLabels> result;
        {
            auto u = Unguard(g);
            result = Impl_->Convert(foreign);
        }

        Cache_.Insert(foreignStr, result);

        return result;
    }

private:
    const ILabelConverterPtr Impl_;

    TAdaptiveLock CacheLock_;
    mutable TLFUCache<TString, TMaybe<NMonitoring::TLabels>> Cache_;
};

ILabelConverterPtr MakeCaching(ILabelConverterPtr impl, size_t size) {
    return ::MakeHolder<TCachingConverter>(std::move(impl), size);
}

} // namespace NAgent
} // namespace NSolomon
