#include <library/cpp/getopt/last_getopt.h>

#include <solomon/agent/modules/agent/graphite/protos/graphite_config.pb.h>
#include <solomon/agent/modules/agent/graphite/decoder.h>

#include <library/cpp/monlib/metrics/labels.h>

#include <util/stream/file.h>
#include <util/string/builder.h>

#include <google/protobuf/text_format.h>

using namespace NMonitoring;

TString PrintLabels(const TLabels& labels) {
    TStringBuilder sb;
    sb << "{ ";
    for (auto&& label: labels) {
        sb << label << " ";
    }

    sb << "}";
    return sb;
}

int main(int argc, char** argv) {
    using namespace NLastGetopt;
    using namespace NSolomon::NAgent;
    using namespace google::protobuf;

    auto opts = TOpts::Default();

    TString config;
    opts.AddHelpOption();
    opts.AddLongOption('c', "config")
        .StoreResult(&config)
        .Help("Conversion config file")
        .RequiredArgument("CONF_FILE");

    TOptsParseResult parser{&opts, argc, argv};

    TGraphiteConversionConfig conf;
    TFileInput is{config};
    TextFormat::ParseFromString(is.ReadAll(), &conf);

    auto converter = CreateGraphiteLabelConverter(conf);
    TString line;
    while (Cin.ReadLine(line)) {
        try {
            auto labels = converter->Convert(line);

            Cout << line << ": " << (labels ? PrintLabels(*labels) : "<empty>") << Endl;
        } catch (...) {
            Cout << line << ": Error: " << CurrentExceptionMessage() << Endl;
        }
    }
}
