#pragma once

#include <library/cpp/monlib/metrics/fwd.h>
#include <library/cpp/monlib/metrics/labels.h>

#include <util/generic/ptr.h>
#include <util/generic/yexception.h>
#include <util/generic/string.h>

class TBlob;

namespace NSolomon {
namespace NAgent {

class TGraphiteConversionConfig;

class ILabelConverter {
public:
    virtual ~ILabelConverter() = default;
    virtual TMaybe<NMonitoring::TLabels> Convert(TStringBuf) const = 0;
};

using ILabelConverterPtr = THolder<ILabelConverter>;


class IDecoder {
public:
    virtual ~IDecoder() = default;
    virtual void Decode(TStringBuf data, NMonitoring::IMetricConsumer&) const = 0;
};

using IDecoderPtr = THolder<IDecoder>;

ILabelConverterPtr CreateGraphiteLabelConverter(const TGraphiteConversionConfig&);
IDecoderPtr CreateGraphiteDecoder(const TGraphiteConversionConfig&);

class TUnknownMetricException: public yexception {
public:
    explicit TUnknownMetricException(TString name)
        : MetricName{name}
    {
    }

    const TString MetricName;
};

class TFormatException: public yexception {
};

} // namespace NAgent
} // namespace NSolomon
