#include "graphite.h"

#include <solomon/agent/modules/agent/graphite/tcp/tcp.h>

#include <library/cpp/monlib/metrics/metric_registry.h>
#include <library/cpp/monlib/metrics/labels.h>

#include <util/datetime/base.h>

using namespace NMonitoring;

namespace NSolomon {
namespace NAgent {

class TTcpServerStatusListener : public ITcpServerStatusListener {
public:
    TTcpServerStatusListener(TMetricRegistry& metrics, const TLabels& common)
        : Metrics_{metrics}
    {
        TLabels labels = common;
        labels.Add("sensor", "graphite.respTimeMillis");
        RespTimes_ = Metrics_.HistogramRate(labels, ExponentialHistogram(5, 50, 2));

        labels = common;
        labels.Add("sensor", "graphite.requests");
        RequestRate_ = Metrics_.Rate(labels);

        labels = common;
        labels.Add("sensor", "graphite.readBytes");
        BytesRead_ = Metrics_.Rate(labels);
    }

    void OnRequestCompleted(ui64 bytesRead, TDuration time) noexcept override {
        RespTimes_->Record(time.MilliSeconds());
        RequestRate_->Inc();
        BytesRead_->Add(bytesRead);
    }

private:
    TMetricRegistry& Metrics_;

    THistogram* RespTimes_;
    TRate* RequestRate_;
    TRate* BytesRead_;
};

THolder<ITcpServerStatusListener> CreateTcpServerStatusListener(TMetricRegistry& metrics, const TLabels& labels) {
    return ::MakeHolder<TTcpServerStatusListener>(metrics, labels);
}

} // namespace NAgent
} // namespace NSolomon

