#pragma once

#include <util/generic/buffer.h>
#include <util/memory/blob.h>

namespace NSolomon::NAgent {

class TDataStream {
public:
    explicit TDataStream(size_t bufferSize)
        : ReadBuffer_{bufferSize}
    {
    }

    char* ReadBuf() {
        return ReadBuffer_.Pos() + Offset_;
    }

    size_t Avail() const {
        return ReadBuffer_.Avail() - Offset_;
    }

    TBlob AsBlob() const {
        return TBlob::NoCopy(ReadBuffer_.Pos(), Offset_);
    }

    void MarkWritten(size_t len) {
        Offset_ += len;
    }

    void MarkRead(size_t len) {
        ReadBuffer_.Advance(len);
        Offset_ -= len;

        if ((ReadBuffer_.Size() + Offset_) * 1.5 > ReadBuffer_.Capacity()) {
            // XXX: we have to chop head of the buffer manually since in our case we have
            // stuff after the Pos()
            memmove(ReadBuffer_.Data(), ReadBuffer_.Pos(), Offset_);
            ReadBuffer_.Clear();
        }
    }

    bool IsFull() const {
        return Avail() == 0;
    }

private:
    TBuffer ReadBuffer_;
    size_t Offset_{0};
};

} // namespace NSolomon::NAgent
